/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.sim.toolkit.designer.message.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.tables.VWRouteWeightTableModel;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWSimulationTab
extends JPanel
implements IVWPropertyTab,
ActionListener,
DocumentListener,
TableModelListener,
IVWPropertyChangeListener,
IVWMapChangedListener,
IVWTableActionListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWMapNode m_mapNode = null;
    private boolean m_bFirstTime = true;
    private VWNumericTextField m_durationTextField = null;
    private JComboBox m_durationComboBox = null;
    private VWTable m_routeWeightTable = null;
    private VWRouteWeightTableModel m_routeWeightTableModel = null;
    private JLabel m_totalWeightLabel = null;
    private JLabel m_totalWeightValueLabel = null;
    private VWLabelListCellRenderer m_customComboBoxRenderer = new VWLabelListCellRenderer();

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_routeWeightTable != null) {
                this.m_routeWeightTable.fitColumnsInTable();
            }
        }
    }

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        this.m_authPropertyData = authPropertyData;
        this.createControls(vwMapNode);
        this.setSelectedStep(vwMapNode);
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
        this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        VWRouteDefinition[] routeDefs;
        try {
            this.m_mapNode = vwMapNode;
            if (this.m_mapNode != null) {
                Object value;
                if (this.m_durationTextField != null) {
                    this.m_durationTextField.getDocument().removeDocumentListener(this);
                    String duration = "0";
                    value = this.getAttributeValue("UI_StepDurationValue");
                    if (value != null && value instanceof String) {
                        duration = (String)value;
                    }
                    this.m_durationTextField.setText(duration);
                    this.m_durationTextField.getDocument().addDocumentListener(this);
                }
                if (this.m_durationComboBox != null) {
                    this.m_durationComboBox.removeActionListener(this);
                    String units = VWSIMResource.s_hours;
                    value = this.getAttributeValue("UI_StepDurationUnits");
                    if (value != null && value instanceof Integer) {
                        switch ((Integer)value) {
                            case 1: {
                                units = VWSIMResource.s_seconds;
                                break;
                            }
                            case 2: {
                                units = VWSIMResource.s_minutes;
                                break;
                            }
                            case 3: {
                                units = VWSIMResource.s_hours;
                            }
                        }
                    }
                    this.m_durationComboBox.setSelectedItem(units);
                    this.m_durationComboBox.addActionListener(this);
                }
                if (this.m_routeWeightTableModel != null) {
                    this.m_routeWeightTableModel.reinitialize(vwMapNode);
                }
                if ((routeDefs = this.m_mapNode.getNextRoutes()) != null && routeDefs.length > 0) {
                    if (routeDefs.length > 1) {
                        switch (this.m_mapNode.getSplitType()) {
                            case 2: {
                                this.m_totalWeightLabel.setVisible(true);
                                this.m_totalWeightValueLabel.setVisible(true);
                                break;
                            }
                            default: {
                                this.m_totalWeightLabel.setVisible(false);
                                this.m_totalWeightValueLabel.setVisible(false);
                                break;
                            }
                        }
                    } else {
                        this.m_totalWeightLabel.setVisible(true);
                        this.m_totalWeightValueLabel.setVisible(true);
                    }
                } else {
                    this.m_totalWeightLabel.setVisible(false);
                    this.m_totalWeightValueLabel.setVisible(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        try {
            this.m_mapNode = vwMapNode;
            if (vwMapNode == null) {
                return;
            }
            if (this.m_routeWeightTableModel != null) {
                this.m_routeWeightTableModel.reinitialize(vwMapNode);
            }
            if ((routeDefs = this.m_mapNode.getNextRoutes()) != null && routeDefs.length > 0) {
                if (routeDefs.length > 1) {
                    switch (this.m_mapNode.getSplitType()) {
                        case 2: {
                            this.m_totalWeightLabel.setVisible(true);
                            this.m_totalWeightValueLabel.setVisible(true);
                            break;
                        }
                        default: {
                            this.m_totalWeightLabel.setVisible(false);
                            this.m_totalWeightValueLabel.setVisible(false);
                            break;
                        }
                    }
                } else {
                    this.m_totalWeightLabel.setVisible(true);
                    this.m_totalWeightValueLabel.setVisible(true);
                }
            } else {
                this.m_totalWeightLabel.setVisible(false);
                this.m_totalWeightValueLabel.setVisible(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        if (this.m_durationTextField != null) {
            this.m_durationTextField.getDocument().removeDocumentListener(this);
            this.m_durationTextField = null;
        }
        if (this.m_durationComboBox != null) {
            this.m_durationComboBox.addActionListener(this);
            this.m_durationComboBox = null;
        }
        this.m_routeWeightTable = null;
        this.m_routeWeightTableModel = null;
        this.m_totalWeightLabel = null;
        this.m_totalWeightValueLabel = null;
        this.m_mapNode = null;
        this.m_authPropertyData = null;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_durationComboBox)) {
                this.performDurationComboBoxAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case 0: {
                this.onUpdateTable();
                break;
            }
            case -1: 
            case 1: {
                int row = event.getLastRow() - 1;
                if (row < 0) {
                    row = 0;
                }
                if (row == this.m_routeWeightTable.getSelectedRow()) {
                    this.m_routeWeightTable.clearSelection();
                }
                if (row < 0 || this.m_routeWeightTableModel.getRowCount() <= 0) break;
                this.m_routeWeightTable.setRowSelectionInterval(row, row);
                break;
            }
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        try {
            if (this.m_mapNode == null) {
                return;
            }
            switch (event.getID()) {
                case 501: {
                    if (this.m_routeWeightTable == null) break;
                    this.m_routeWeightTable.repaint();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        try {
            switch (event.getID()) {
                case 101: 
                case 102: {
                    VWRouteDefinition[] vwRouteDefs = this.m_authPropertyData.getMapChangeEventNotifier().getChangedRoutes();
                    if (vwRouteDefs == null || vwRouteDefs.length <= 0) break;
                    this.setSelectedStep(this.m_mapNode);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_routeWeightTable == null) break;
                this.m_routeWeightTable.stopEditing();
            }
        }
    }

    private void createControls(VWMapNode vwMapNode) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.15;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 15);
            int nStepType = VWStepUtils.getStepType(vwMapNode);
            if (nStepType != 9 && nStepType != 10) {
                this.add((Component)this.getDurationPanel(), gbCons);
            }
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 0.33;
            gbCons.weighty = 1.0;
            this.add((Component)this.createRouteWeightPanel(), gbCons);
            ++gbCons.gridx;
            this.add((Component)new JLabel(" "), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getDurationPanel() {
        VWToolbarBorder durationBorder = new VWToolbarBorder(VWSIMResource.s_duration);
        JPanel durationPanel = durationBorder.getClientPanel();
        durationPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 18;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(2, 0, 0, 0);
        this.m_durationTextField = new VWNumericTextField(6, 0, false);
        this.m_durationTextField.getDocument().addDocumentListener(this);
        durationPanel.add((Component)this.m_durationTextField, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(0, 5, 0, 0);
        this.m_durationComboBox = new JComboBox();
        this.m_durationComboBox.addItem(VWSIMResource.s_seconds);
        this.m_durationComboBox.addItem(VWSIMResource.s_minutes);
        this.m_durationComboBox.addItem(VWSIMResource.s_hours);
        this.m_durationComboBox.setRenderer(this.m_customComboBoxRenderer);
        this.m_durationComboBox.addActionListener(this);
        durationPanel.add((Component)this.m_durationComboBox, gbCons);
        return durationBorder;
    }

    private JPanel createRouteWeightPanel() {
        VWToolbarBorder toolbarPanel = new VWToolbarBorder(VWSIMResource.s_routeWeight);
        JPanel panel = toolbarPanel.getClientPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 17;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 1;
        gbCons.weightx = 0.1;
        gbCons.weighty = 1.0;
        gbCons.insets = new Insets(0, 0, 0, 0);
        gbCons.gridheight = 1;
        gbCons.gridwidth = 2;
        this.m_routeWeightTableModel = new VWRouteWeightTableModel(this.m_authPropertyData);
        this.m_routeWeightTableModel.addTableModelListener(this);
        this.m_routeWeightTable = new VWTable(this.m_routeWeightTableModel);
        this.m_routeWeightTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        panel.add((Component)new JScrollPane(this.m_routeWeightTable), gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 13;
        gbCons.gridwidth = 1;
        this.m_totalWeightLabel = new JLabel(VWSIMResource.s_totalWeight);
        panel.add((Component)this.m_totalWeightLabel, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.anchor = 17;
        gbCons.gridwidth = 0;
        this.m_totalWeightValueLabel = new JLabel("0%");
        panel.add((Component)this.m_totalWeightValueLabel, gbCons);
        return toolbarPanel;
    }

    private void handleDocumentEvent(DocumentEvent event) {
        if (event.getDocument() == this.m_durationTextField.getDocument()) {
            String durationString = this.m_durationTextField.getText();
            this.setAttributeValue("UI_StepDurationValue", durationString);
        }
    }

    private void performDurationComboBoxAction() {
        int nUnits = 1;
        String unitString = (String)this.m_durationComboBox.getSelectedItem();
        if (VWStringUtils.compare(unitString, VWSIMResource.s_seconds) == 0) {
            nUnits = 1;
        } else if (VWStringUtils.compare(unitString, VWSIMResource.s_minutes) == 0) {
            nUnits = 2;
        } else if (VWStringUtils.compare(unitString, VWSIMResource.s_hours) == 0) {
            nUnits = 3;
        }
        try {
            this.setAttributeValue("UI_StepDurationUnits", new Integer(nUnits));
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateTable() {
        int totalWeight = this.m_routeWeightTableModel.getTotalWeight();
        this.m_totalWeightValueLabel.setText(totalWeight + "%");
        if (totalWeight > 100) {
            ImageIcon icon = VWSIMImageLoader.createImageIcon("error.gif");
            this.m_totalWeightValueLabel.setIcon(icon);
            this.m_totalWeightValueLabel.setHorizontalTextPosition(10);
        } else {
            this.m_totalWeightValueLabel.setIcon(null);
        }
    }

    private void setAttributeValue(String fieldName, Object value) {
        try {
            if (this.m_mapNode == null) {
                return;
            }
            VWAttributeInfo attributeInfo = this.m_mapNode.getAttributeInfo();
            if (attributeInfo == null) {
                attributeInfo = new VWAttributeInfo();
            }
            attributeInfo.setFieldValue(fieldName, value);
            this.m_mapNode.setAttributeInfo(attributeInfo);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object getAttributeValue(String fieldName) {
        try {
            if (this.m_mapNode == null) {
                return null;
            }
            VWAttributeInfo attributeInfo = this.m_mapNode.getAttributeInfo();
            if (attributeInfo != null) {
                return attributeInfo.getFieldValue(fieldName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

